/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.ast.util;

import icyllis.flexmark.ast.HardLineBreak;
import icyllis.flexmark.ast.HtmlEntity;
import icyllis.flexmark.ast.HtmlInline;
import icyllis.flexmark.ast.SoftLineBreak;
import icyllis.flexmark.ast.Text;
import icyllis.flexmark.ast.TextBase;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.ast.NodeVisitor;
import icyllis.flexmark.util.ast.VisitHandler;
import icyllis.flexmark.util.sequence.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineCollectingVisitor {
    private final NodeVisitor myVisitor = new NodeVisitor(new VisitHandler<Text>(Text.class, this::visit), new VisitHandler<TextBase>(TextBase.class, this::visit), new VisitHandler<HtmlEntity>(HtmlEntity.class, this::visit), new VisitHandler<HtmlInline>(HtmlInline.class, this::visit), new VisitHandler<SoftLineBreak>(SoftLineBreak.class, this::visit), new VisitHandler<HardLineBreak>(HardLineBreak.class, this::visit));
    private List<Range> myLines = Collections.EMPTY_LIST;
    private List<Integer> myEOLs;
    private int myStartOffset;
    private int myEndOffset;

    private void finalizeLines() {
        if (this.myStartOffset < this.myEndOffset) {
            Range range = Range.of(this.myStartOffset, this.myEndOffset);
            this.myLines.add(range);
            this.myEOLs.add(0);
            this.myStartOffset = this.myEndOffset;
        }
    }

    public List<Range> getLines() {
        this.finalizeLines();
        return this.myLines;
    }

    public List<Integer> getEOLs() {
        this.finalizeLines();
        return this.myEOLs;
    }

    public void collect(Node node) {
        this.myLines = new ArrayList<Range>();
        this.myEOLs = new ArrayList<Integer>();
        this.myStartOffset = node.getStartOffset();
        this.myEndOffset = node.getEndOffset();
        this.myVisitor.visit(node);
    }

    public List<Range> collectAndGetRanges(Node node) {
        this.collect(node);
        return this.getLines();
    }

    private void visit(SoftLineBreak node) {
        Range range = Range.of(this.myStartOffset, node.getEndOffset());
        this.myLines.add(range);
        this.myEOLs.add(node.getTextLength());
        this.myStartOffset = node.getEndOffset();
    }

    private void visit(HardLineBreak node) {
        Range range = Range.of(this.myStartOffset, node.getEndOffset());
        this.myLines.add(range);
        this.myEOLs.add(node.getTextLength());
        this.myStartOffset = node.getEndOffset();
    }

    private void visit(HtmlEntity node) {
        this.myEndOffset = node.getEndOffset();
    }

    private void visit(HtmlInline node) {
        this.myEndOffset = node.getEndOffset();
    }

    private void visit(Text node) {
        this.myEndOffset = node.getEndOffset();
    }

    private void visit(TextBase node) {
        this.myEndOffset = node.getEndOffset();
    }
}

